/*! \file    
**********************************************************************************	
* Title:						Discretix SST API Source file						 					
*																			
* Filename:						sst_api.c															
*																			
* Project, Target, subsystem:	SST 6.0, Stubs, API
* 
* Created:						11.03.2007														
*
* Modified:						07.06.2007										
*
* \Author						Raviv levi														
*																			
* \Remarks						
*           Copyright (C) 2006 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

/*----------- External include files ----------------------------------------*/
#include "DX_VOS_Mem.h"
#include "dx_hw_defs.h"
#include "sst_host_op_code.h"
/*----------- Local include files -------------------------------------------*/
#include "sst_data_operations.h"



/*---------------------------------------------------------------------------*/
/*               API FUNCTIONS                                               */
/*---------------------------------------------------------------------------*/

 /*Basic DB services*/

/*SST_DataInsert*/
DxError_t SST_DataInsert(SSTTxnId_t        aTransactionId,
                         SSTSessionId_t    aSessionId, 
                         SSTHandle_t       aInitialCtrlAuth,       
                         DxByte_t         *aDataIn_ptr,
                         DxUint32_t        aDataInsizeInBytes,
                         DxBool_t          aEncrypt,
                         SSTDataType_t     aDataType,                
                         SSTHandle_t      *aDataHandle_ptr,
                         DxByte_t         *aWorkspace_ptr,
                         DxUint32_t        aWorkspaceSizeInBytes)

{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_DATA_INSERT, 11,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aSessionId, 
                                 aInitialCtrlAuth,       
                                 aDataIn_ptr,
                                 aDataInsizeInBytes,
                                 aEncrypt,
                                 aDataType,                
                                 aDataHandle_ptr,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}


/*SST_DataReadOnlySet*/
DxError_t SST_DataReadOnlySet(SSTTxnId_t      aTransactionId,
                              SSTSessionId_t  aSessionId, 
                              SSTHandle_t     aObjHandle,
                              DxByte_t       *aWorkspace_ptr,
                              DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_DATA_READ_ONLY_SET, 6,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aSessionId, 
                                 aObjHandle,       
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}



/*SST_DataRead*/
DxError_t SST_DataRead(SSTSessionId_t  aSessionId,
                       SSTHandle_t     aDataHandle,
                       DxUint32_t      aDataOffset,
                       DxByte_t       *aDataOut_ptr,
                       DxUint32_t     *aDataSizeInBytes_ptr,
                       DxByte_t       *aWorkspace_ptr,
                       DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_DATA_READ, 8,
	   							 /* PARAMETERS: */
                                   aSessionId,
                                   aDataHandle,
                                   aDataOffset,
                                   aDataOut_ptr,
                                   aDataSizeInBytes_ptr,
                                   aWorkspace_ptr,
                                   aWorkspaceSizeInBytes );
}



/*SST_DataModify*/
DxError_t SST_DataModify(SSTTxnId_t      aTransactionId,
                         SSTSessionId_t  aSessionId,                           
                         SSTHandle_t     aDataHandle,   
                         DxByte_t       *aDataIn_ptr,
                         DxUint32_t      aDataSizeInBytes,
                         DxUint32_t      aDataOffset,
                         DxByte_t       *aWorkspace_ptr,
                         DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_DATA_MODIFY, 9,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aSessionId,                           
                                 aDataHandle,   
                                 aDataIn_ptr,
                                 aDataSizeInBytes,
                                 aDataOffset,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}



/*SST_DataSizeGet*/
DxError_t SST_DataSizeGet(SSTSessionId_t  aSessionId,  
                          SSTHandle_t     aDataHandle,
                          DxUint32_t     *aDatasizeInBytes_ptr,
                          DxByte_t       *aWorkspace_ptr,
                          DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_DATA_SIZE_GET, 6,
	   							 /* PARAMETERS: */
                                  aSessionId,  
                                  aDataHandle,
                                  aDatasizeInBytes_ptr,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
}



/*SST_DataDelete*/
DxError_t SST_DataDelete(SSTTxnId_t      aTransactionId,
                         SSTSessionId_t  aSessionId,  
                         SSTHandle_t     aDataHandle,
                         DxByte_t       *aWorkspace_ptr,
                         DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_DATA_DELETE, 6,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aSessionId,  
                                 aDataHandle,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}



/*SST_TransactionStart*/
DxError_t SST_TransactionStart(SSTTxnId_t *aTransactionId_ptr)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_TRANSACTION_START, 1,
	   							 /* PARAMETERS: */
                                 aTransactionId_ptr );
}



/*SST_TransactionEnd*/
DxError_t SST_TransactionEnd(SSTTxnId_t aTransactionId,
							 DxBool_t	aIsReflashSensitive,
							 DxByte_t   *aWorkspace_ptr,
							 DxUint32_t aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_TRANSACTION_END, 4,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aIsReflashSensitive,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}

/*SST_TransactionRollback*/
DxError_t SST_TransactionRollback(SSTTxnId_t aTransactionId,
								  DxByte_t   *aWorkspace_ptr,
								  DxUint32_t aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_TRANSACTION_ROLLBACK, 3,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}


/*SST_DataReplace*/
DxError_t SST_DataReplace(SSTTxnId_t      aTransactionId,
                          SSTSessionId_t  aSessionId,                           
                          SSTHandle_t     aDataHandle,   
                          DxByte_t       *aNewData_ptr,
                          DxUint32_t      aNewDataSizeInBytes,
                          DxBool_t        aEncrypt,
                          DxByte_t       *aWorkspace_ptr,
                          DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_DATA_REPLACE, 9,
	   							 /* PARAMETERS: */
                                  aTransactionId,
                                  aSessionId,                           
                                  aDataHandle,   
                                  aNewData_ptr,
                                  aNewDataSizeInBytes,
                                  aEncrypt,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
}
